	% "Bounding box" on the poles and zeros
	clc
	clear all
	close all
	fs = 10; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	Amax0 = 2;	Amin0 = 40;	Wc0 = 1;	Ws0 = 1.3;
	N = CA_ORDER_S(Wc0, Ws0, Amax0, Amin0)	
	N0 = 5;
	
	% Case D3a 
	% Amax0, Wc0, MIN(Ws), Amin0
	subplot(2,1,1); % figure(1)
	[G0, Zeros(:,1), R_ZEROS, Poles(:,1), Wsnew] = CA_POLES_S(Wc0, Ws0, Amax0, Amin0, N0);
	Wsmin = Wsnew;
	omega = [0:Ws0/1000:2*Ws0];
	Att = PZ_2_ATT_S(G0, Zeros(:,1), Poles(:,1), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	%	subplot('position', [0.1 0.50 0.80 0.40])
	%	PLOT_ATT_S(omega, Att)
	axis([0 2*Ws0 0 50]);
	zoom on    
	hold on
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	
	% Case D1
	% Amax0, Wc0, Ws0, MAX(Amin)
	subplot(2,1,2); %figure(2)
	Amin = Amin0;
	N = N0-1;
	while N  <= N0
		Amin = Amin*1.001;
		N = CA_ORDER_S(Wc0, Ws0, Amax0, Amin);
	end
	AminMAX = Amin/1.001;
	[G, Zeros(:,2), R_ZEROS, Poles(:,2), Wsnew] = CA_POLES_S(Wc0, Ws0, Amax0, AminMAX, N0);	
	Att = PZ_2_ATT_S(G, Zeros(:,2), Poles(:,2), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	%	subplot('position', [0.1 0.55 0.80 0.40])
	%	PLOT_ATT_S(omega, Att)
	axis([0 2*Ws0 0 50]);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	zoom on
	
	% Case D2
	% MIN(Amax), Wc0, Ws0, Amin0
	figure(2)
	subplot(2,1,1); %	figure(3)
	Amax = Amax0;
	N = N0-1;
	while N  <= N0
		N = CA_ORDER_S(Wc0, Ws0, Amax, Amin0);
		Amax = Amax*0.999;
	end
	AmaxMIN = Amax;
	[G, Zeros(:,3), R_ZEROS, Poles(:,3), Wsnew] = CA_POLES_S(Wc0, Ws0, AmaxMIN, Amin0, N0);		
	Att = PZ_2_ATT_S(G, Zeros(:,3), Poles(:,3), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	axis([0 2*Ws0 0 50]);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	zoom on
	
	% Case D3b
	% Amax0, MAX(Wc0), Ws0, Amin0
	subplot(2,1,2);
	N = N0; Wc = Wc0;
	while N <= N0
		N = CA_ORDER_S(Wc, Ws0, Amax0, Amin0);
		Wc = Wc*1.0001;
	end
	Wcmax = Wc;
	[G, Zeros(:,4), R_ZEROS, Poles(:,4), Wsnew] = CA_POLES_S(Wcmax, Ws0, Amax0, Amin0, N0);
	Att = PZ_2_ATT_S(G, Zeros(:,4), Poles(:,4), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	axis([0 2*Ws0 0 50]);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	zoom on
	
	% Case D4b
	% Amax < Amax0, Wc < Wc0, Ws0, Amin0
	figure(3)
	subplot(2,1,1); %
	N = N0-1;	Amax = Amax0; Wc1 = 0.949;
	while N <= N0
		N = CA_ORDER_S(Wc1, Ws0, Amax, Amin0);
		Amax = Amax*0.999;
	end
	Att = Amax/0.999;
	[G, Zeros(:,5), R_ZEROS, Poles(:,5), Wsnew] = CA_POLES_S(Wc1, Ws0, Amax, Amin0, N0);
	Att = PZ_2_ATT_S(G, Zeros(:,5), Poles(:,5), Wc0);
	Att = PZ_2_ATT_S(G, Zeros(:,5), Poles(:,5), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	axis([0 2*Ws0 0 50]);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	zoom on
	
	%	figure(6)
	% Case D4a
	% Amax < Amax0, Wc < Wc0, Ws0, Amin0
	subplot(2,1,2);
	Att = Amin0+0.01;Wsnew = 1.369;
	N = N0-1;	Amax = Amax0; Amin = Amin0;
	while N <= N0
		N = CA_ORDER_S(Wc0, Wsnew, Amax0, Amin);
		Amin = Amin+0.01;
	end
	[G, Zeros(:,6), R_ZEROS, Poles(:,6), Wsnew] = CA_POLES_S(Wc0, Wsnew, Amax0, Amin, N0);
	Att = PZ_2_ATT_S(G, Zeros(:,6), Poles(:,6), Ws0)
	Att = PZ_2_ATT_S(G, Zeros(:,6), Poles(:,6), omega);
	Att(Att > 50) = 50;
	plot(omega, Att,'linewidth',lw,'color','k')
	axis([0 2*Ws0 0 50]);
	color = [0.7 0.7 0.7]; % Gray
	V = axis;
	patch([0 Wc0 Wc0 0], [Amax0 Amax0 V(4) V(4)], color); 
	patch([Ws0 V(2) V(2) Ws0], [0 0 Amin0 Amin0], color);
	zoom on
	
	figure(4)
	% PLOT_PZ_S([], Poles, -2*Wc0, 2*Ws0, -Wc0, 0.5*Wc0, 2*Ws0)
	%========================================================	
	
	ax = newplot;
	set(gca,'FontName', fn,'FontSize', fs);
	set(ax,'ylim',[-0.1 Ws0]*1.6,'fontsize',fs,'linewidth', lw, 'fontname', fn);
	set(ax,'xlim',[-Wc0  0.5*Wc0]);
	daspect([1 1 1]);
	hold on
	% Plot axes	
	line([0 0],[-0.05 Ws0]*1.6,'linewidth', lw);
	line([-Wc0 0.5*Wc0], [0 0],'linewidth', lw);
	Poles(imag(Poles) < 0) = [];
	Zeros(imag(Zeros) < 0) = [];
	fs = 18;
	plot(Poles, 'k.','markersize', fs,'linewidth', 1);
	hold on
	plot(Zeros, 'k.','markersize', fs,'linewidth', 1);
	hold on
	zoom on
grid on
	
	
	
	
	
	
	
